function [e, m] = test10(cleanup, level)
%TEST10   psnewdoc, psgetpixels, pssetpixels. Stress testing. Level needs
%to be larger than 1. Photoshop is very good at opening large files but
%will take some time to process. MATLAB will fail much earlier but will run
%much faster. When Photoshop creates a very large file it takes very little
%memory. When you write to each pixel it creates the data needed to hold
%the pixels. This test will create a file, run a gradient in Photoshop,
%then try to read/write pixels to MATLAB.
%
% Each test stops if time takes longer than 'operationmaxtime', currently 30.
% Each test goes from 1000x1000 in increments of 1000. 'width' and 'inc'.
% 1. Figure out how big a file I can make in Photoshop with a gradient.
% 2. Figure out how big a matrix I can make in MATLAB.
% 3. Figure out how many pixels I can push between the two. Read/Write must
% both pass.

%   Thomas Ruark, 5/10/2006
%   Copyright 2006 Adobe Systems, Inc.

e = 'PASS';
startwidth = 1000;
width = startwidth;
openedit = false;
inc = 1000;

operationmaxtime = 30; % stop of PS gradient takes more than 30 seconds

pstimingopen = [];
pstiminggrad = [];
pstimingmatlab = [];
pstimingread = [];
pstimingwrite = [];
m = zeros(1,3);
maxsize = 0;

keeprunning = true;

if level > 0

    try
        [oru, otu, oh, odd] = psconfig('pixels', 'pixels', 5, 'no');

        % Step 1: (see above)
        while keeprunning
            step = 1;
            % [oru, otu, oh, odd] = psconfig('pixels', 'pixels', 5, 'no');
            tic;
            psnewdoc(width, width, 72, [num2str(width) 'x' num2str(width)]);
            pstimingopen = [pstimingopen toc];
            openedit = true;
            step = 2;
            [w, h, r, n] = psdocinfo();
            if width ~= w || width ~= h
                error('test10:badcreate', 'width and height do not match creation params');
            end
            tic;
            rungradient();
            pstiminggrad = [pstiminggrad toc];
            maxsize = prod([w h psnumchannels()]);
            disp(['Gradient timing width: ' num2str(width) ', toc: ' num2str(pstiminggrad(end))]);
            pause(1);
            if pstiminggrad(end) > operationmaxtime
                disp(['Gradient d timing width: ' num2str(width)]);
                keeprunning = false;
                % error('Out of time!');
            end
            psclosedoc(1);
            openedit = false;
            width = width + inc;
        end

        m(1) = maxsize;
        
        % reset
        keeprunning = true;
        width = startwidth;
        maxsize = 0;

        % Step 2: (see above)
        while keeprunning
            try
                tic;
                a = uint8(ones(width, width));
                pstimingmatlab = [pstimingmatlab toc];
                maxsize = prod(size(a));
                disp(['MATLAB timing width: ' num2str(width) ', toc: ' num2str(pstimingmatlab(end))]);
                pause(1);
                if pstimingmatlab(end) > operationmaxtime
                    disp(['MATLAB d timing width: ' num2str(width)]);
                    keeprunning = false;
                    clear('a');
                    % error('Out of time!');
                else
                    width = width + inc;
                end
            catch
                width = width - inc;
                disp(['MATLAB e timing width: ' num2str(width)]);
                keeprunning = false;
                clear('a');
            end
        end

        m(2) = maxsize;
        
        % reset
        keeprunning = true;
        width = startwidth;
        maxsize = 0;
        
        % Step 3: (see above)
        while keeprunning
            try
                step = 1;
                % [oru, otu, oh, odd] = psconfig('pixels', 'pixels', 5, 'no');
                psnewdoc(width, width, 72, [num2str(width) 'x' num2str(width)]);
                openedit = true;
                rungradient();

                tic;
                r = psgetpixels();
                pstimingread = [pstimingread toc];
                step = 3;
                r(:) = 0;
                tic;
                pssetpixels(r);
                pstimingwrite = [pstimingwrite toc];
                maxsize = prod(size(r));
                % totaltime = pstimingopen(end) + pstiminggrad(end) + pstimingread(end) + pstimingwrite(end);
                totaltime = pstimingread(end) + pstimingwrite(end);
                disp(['psgetsetpixels timing width: ' num2str(width) ', toc: ' num2str(totaltime)]);
                pause(1);
                if totaltime > operationmaxtime
                    disp(['psgetsetpixels d timing width: ' num2str(width)]);
                    keeprunning = false;
                    % error('Out of time!');
                else
                    width = width + inc;
                end
                step = 4;
                psclosedoc(1);
                openedit = false;
            catch
                width = width - inc;
                disp(['psgetsetpixels e timing width: ' num2str(width)]);
                keeprunning = false;
            end
        end

        m(3) = maxsize;
        
        m = m / (1024*1024);
        
        psconfig(oru, otu, oh, odd);

        if exist('cleanup', 'var') && cleanup
            while psnumdocs()
                psclosedoc(1);
            end
        end
    catch
        if openedit
            psclosedoc(1);
        end
        width = width - inc;
        % failcount = failcount + 1;
    end

    pslogit(['Max file size: ' num2str(m)], true, true, [strrep(which('testall'), 'testall.m', '') 'pstestlog.log']);

end

%a = pstimingopen;
%b = pstiminggrad;
%c = pstimingmatlab;
%d = pstimingread;
%e = pstimingwrite;

function [] =  rungradient()
pstext = [ 'var id32 = charIDToTypeID( "Grdn" );' ...
    'var desc5 = new ActionDescriptor();' ...
    'var id33 = charIDToTypeID( "From" );' ...
    '        var desc6 = new ActionDescriptor();' ...
    '        var id34 = charIDToTypeID( "Hrzn" );' ...
    '        var id35 = charIDToTypeID( "#Prc" );' ...
    '        desc6.putUnitDouble( id34, id35, 2.777778 );' ...
    '        var id36 = charIDToTypeID( "Vrtc" );' ...
    '        var id37 = charIDToTypeID( "#Prc" );' ...
    '        desc6.putUnitDouble( id36, id37, 3.888889 );' ...
    '    var id38 = charIDToTypeID( "Pnt " );' ...
    '    desc5.putObject( id33, id38, desc6 );' ...
    '    var id39 = charIDToTypeID( "T   " );' ...
    '        var desc7 = new ActionDescriptor();' ...
    '        var id40 = charIDToTypeID( "Hrzn" );' ...
    '        var id41 = charIDToTypeID( "#Prc" );' ...
    '        desc7.putUnitDouble( id40, id41, 95.039683 );' ...
    '        var id42 = charIDToTypeID( "Vrtc" );' ...
    '        var id43 = charIDToTypeID( "#Prc" );' ...
    '        desc7.putUnitDouble( id42, id43, 94.444444 );' ...
    '    var id44 = charIDToTypeID( "Pnt " );' ...
    '    desc5.putObject( id39, id44, desc7 );' ...
    '    var id45 = charIDToTypeID( "Type" );' ...
    '    var id46 = charIDToTypeID( "GrdT" );' ...
    '    var id47 = charIDToTypeID( "Lnr " );' ...
    '    desc5.putEnumerated( id45, id46, id47 );' ...
    '    var id48 = charIDToTypeID( "Dthr" );' ...
    '    desc5.putBoolean( id48, true );' ...
    '    var id49 = charIDToTypeID( "UsMs" );' ...
    '    desc5.putBoolean( id49, true );' ...
    '    var id50 = charIDToTypeID( "Grad" );' ...
    '        var desc8 = new ActionDescriptor();' ...
    '        var id51 = charIDToTypeID( "Nm  " );' ...
    '        desc8.putString( id51, "Foreground to Background" );' ...
    '        var id52 = charIDToTypeID( "GrdF" );' ...
    '        var id53 = charIDToTypeID( "GrdF" );' ...
    '        var id54 = charIDToTypeID( "CstS" );' ...
    '        desc8.putEnumerated( id52, id53, id54 );' ...
    '        var id55 = charIDToTypeID( "Intr" );' ...
    '        desc8.putDouble( id55, 4096.000000 );' ...
    '        var id56 = charIDToTypeID( "Clrs" );' ...
    '            var list1 = new ActionList();' ...
    '                var desc9 = new ActionDescriptor();' ...
    '                var id57 = charIDToTypeID( "Type" );' ...
    '                var id58 = charIDToTypeID( "Clry" );' ...
    '                var id59 = charIDToTypeID( "FrgC" );' ...
    '                desc9.putEnumerated( id57, id58, id59 );' ...
    '                var id60 = charIDToTypeID( "Lctn" );' ...
    '                desc9.putInteger( id60, 0 );' ...
    '                var id61 = charIDToTypeID( "Mdpn" );' ...
    '                desc9.putInteger( id61, 50 );' ...
    '            var id62 = charIDToTypeID( "Clrt" );' ...
    '            list1.putObject( id62, desc9 );' ...
    '                var desc10 = new ActionDescriptor();' ...
    '                var id63 = charIDToTypeID( "Type" );' ...
    '                var id64 = charIDToTypeID( "Clry" );' ...
    '                var id65 = charIDToTypeID( "BckC" );' ...
    '                desc10.putEnumerated( id63, id64, id65 );' ...
    '                var id66 = charIDToTypeID( "Lctn" );' ...
    '                desc10.putInteger( id66, 4096 );' ...
    '                var id67 = charIDToTypeID( "Mdpn" );' ...
    '                desc10.putInteger( id67, 50 );' ...
    '            var id68 = charIDToTypeID( "Clrt" );' ...
    '            list1.putObject( id68, desc10 );' ...
    '        desc8.putList( id56, list1 );' ...
    '        var id69 = charIDToTypeID( "Trns" );' ...
    '            var list2 = new ActionList();' ...
    '                var desc11 = new ActionDescriptor();' ...
    '                var id70 = charIDToTypeID( "Opct" );' ...
    '                var id71 = charIDToTypeID( "#Prc" );' ...
    '                desc11.putUnitDouble( id70, id71, 100.000000 );' ...
    '                var id72 = charIDToTypeID( "Lctn" );' ...
    '                desc11.putInteger( id72, 0 );' ...
    '                var id73 = charIDToTypeID( "Mdpn" );' ...
    '                desc11.putInteger( id73, 50 );' ...
    '            var id74 = charIDToTypeID( "TrnS" );' ...
    '            list2.putObject( id74, desc11 );' ...
    '                var desc12 = new ActionDescriptor();' ...
    '                var id75 = charIDToTypeID( "Opct" );' ...
    '                var id76 = charIDToTypeID( "#Prc" );' ...
    '                desc12.putUnitDouble( id75, id76, 100.000000 );' ...
    '                var id77 = charIDToTypeID( "Lctn" );' ...
    '                desc12.putInteger( id77, 4096 );' ...
    '                var id78 = charIDToTypeID( "Mdpn" );' ...
    '                desc12.putInteger( id78, 50 );' ...
    '            var id79 = charIDToTypeID( "TrnS" );' ...
    '            list2.putObject( id79, desc12 );' ...
    '        desc8.putList( id69, list2 );' ...
    '    var id80 = charIDToTypeID( "Grdn" );' ...
    '    desc5.putObject( id50, id80, desc8 );' ...
    'executeAction( id32, desc5, DialogModes.NO );'];

% psjavascriptu('app.doAction("Gradient", "Gradient")');
psresult = psjavascriptu(pstext);

